local c;
local cf;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local NumberPulse = THEME:GetMetric("Combo", "NumberPulseCommand");
local LabelPulse = THEME:GetMetric("Combo", "LabelPulseCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local FullComboCommands = {
	W1 = THEME:GetMetric("Combo","FullComboW1Command");
	W2 = THEME:GetMetric("Combo","FullComboW2Command");
	W3 = THEME:GetMetric("Combo","FullComboW3Command");
	Broken = THEME:GetMetric("Combo","FullComboBrokenCommand");
};

local ShowFlashyCombo = GetUserPrefB("UserPrefFlashyCombo")


local t = Def.ActorFrame {
	InitCommand=cmd(vertalign,bottom);
 	LoadActor(THEME:GetPathG("Combo","100Milestone")) .. {
		Name="OneHundredMilestone";
		InitCommand=cmd(visible,ShowFlashyCombo);
		FiftyMilestoneCommand=cmd(playcommand,"Milestone");
	};

	Def.ActorFrame {
		Name="ComboFrame";
		LoadFont( "Combo", "numbers" ) .. {
			Name="Number";
			OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
		};
		LoadActor("_combo") .. {
			Name="Label";
			OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
		};
	};

	InitCommand = function(self)
		c = self:GetChildren();
		cf = c.ComboFrame:GetChildren();
		cf.Number:visible(false);
		cf.Label:visible(false);
	end;
	
 	TwentyFiveMilestoneCommand=function(self,parent)
		if ShowFlashyCombo then
			(cmd(skewy,-0.125;decelerate,0.325;skewy,0))(self);
		end;
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			cf.Number:visible(false);
			cf.Label:visible(false);
			return;
		end
		
		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		cf.Number:visible(true);
		cf.Label:visible(true);
		cf.Number:settext( string.format("%i", iCombo) );

		local cmdToPlay;
		if param.FullComboW1 then
			cmdToPlay = FullComboCommands["W1"];
		elseif param.FullComboW2 then
			cmdToPlay = FullComboCommands["W2"];
		elseif param.FullComboW3 then
			cmdToPlay = FullComboCommands["W3"];
		else
			cmdToPlay = FullComboCommands["Broken"];
		end;
		(cmdToPlay)(cf.Number, param );
		(cmdToPlay)(cf.Label, param );
		
		NumberPulse( cf.Number, param );
		LabelPulse( cf.Label, param );
	end;
};

return t;
